﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using ArcheBuddy.Bot.Classes;


namespace AutoExp.Quests
{
    internal class Quest_1709 : Quest
    {
        public Quest_1709(int minLvl, int maxLvl, QuestRace race, uint[] reqQuests)
            : base(1709, minLvl, maxLvl, race, reqQuests)
        { }

        public override bool RunQuest(Host host)
        {
            if (!base.RunQuest(host))
                return false;

            if (getQuest() == null)
            {
                if (!host.movementModule.GpsMove("Headlands_Samud")) return false;
                Thread.Sleep(1000);
                host.StartQuest(id);
                Thread.Sleep(1000);
            }

            ArcheBuddy.Bot.Classes.Quest quest = getQuest();

            if (!checkQuestCompletedOrAccepted(947))
                return false;
            if (!checkQuestCompletedOrPerfomed(784))
                return false;
            if (!checkQuestCompletedOrPerfomed(3678))
                return false;
            if (!checkQuestCompletedOrPerfomed(3677))
                return false;

            if (quest != null && quest.status == QuestStatus.Accepted)
            {
                Zone zone = new RoundZone(16311.63, 7716.91, 80);
                if (!host.movementModule.GpsMove("Quest_784_1")) return false;
                host.farmModule.SetFarmMobs(zone, new uint[] { 2942 });
                while (host.farmModule.farmState == Modules.FarmState.Enabled && quest.status == QuestStatus.Accepted)
                    Thread.Sleep(100);
                host.farmModule.StopFarm();
                Thread.Sleep(1000);
            }

            if (!checkQuestCompletedOrPerfomed(947))
                return false;
            if (!checkQuestCompletedOrPerfomed(784))
                return false;
            if (!checkQuestCompletedOrPerfomed(3678))
                return false;
            if (!checkQuestCompletedOrPerfomed(3677))
                return false;

            if (quest != null && quest.status == QuestStatus.Performed)
            {
                if (!host.movementModule.GpsMove("Headlands_Samud"))
                    return false;
                host.CompleteQuest(id);
                Thread.Sleep(1000);
            }

            return true;
        }
    }
}
